/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedona.Depend;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.ast.DependDef;
import sedonac.ir.IrKit;
import sedonac.steps.ReadKits;

public class ResolveDepends
extends ReadKits {
    public void run() {
        DependDef[] dependDefArray = this.compiler.ast.depends;
        if (dependDefArray == null || dependDefArray.length == 0) {
            this.compiler.kits = new IrKit[0];
            return;
        }
        this.log.debug("  ResolveDepends");
        IrKit[] irKitArray = new IrKit[dependDefArray.length];
        int n = 0;
        while (n < dependDefArray.length) {
            irKitArray[n] = this.resolveDepend(dependDefArray[n]);
            ++n;
        }
        this.compiler.kits = irKitArray;
        this.quitIfErrors();
        n = 0;
        while (n < irKitArray.length) {
            this.resolveRecursive(irKitArray[n], null);
            ++n;
        }
        this.quitIfErrors();
    }

    protected IrKit resolveDepend(DependDef dependDef) {
        KitFile kitFile = KitDb.matchBest((Depend)dependDef.depend);
        if (kitFile == null) {
            this.err("Missing kit dependency '" + dependDef.depend + '\'', dependDef.loc);
            return null;
        }
        this.log.debug("    Resolve '" + dependDef.depend + "' -> " + kitFile);
        try {
            IrKit irKit = new IrKit(dependDef.loc, kitFile);
            this.readKit(irKit);
            return irKit;
        }
        catch (CompilerException compilerException) {
            return null;
        }
    }

    protected void resolveRecursive(IrKit irKit, String string) {
        Depend[] dependArray = irKit.manifest.depends;
        int n = 0;
        while (n < dependArray.length) {
            String string2;
            Depend depend = dependArray[n];
            IrKit irKit2 = (IrKit)this.ns.resolveKit(depend.name());
            String string3 = string2 = string == null ? irKit.name : string + "->" + irKit.name;
            if (irKit2 == null) {
                this.err("Dependency on '" + depend.name() + "' required through '" + string2 + '\'', new Location(this.compiler.input));
            } else {
                this.resolveRecursive(irKit2, string2);
            }
            ++n;
        }
    }

    public ResolveDepends(Compiler compiler) {
        super(compiler);
    }
}

